/**
* \file: NaviTtsAudioChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample audio channel implementation for navigation text to speech
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_NAVITTSAUDIOCHANNEL_H
#define BDCL_NAVITTSAUDIOCHANNEL_H

#include <bdcl/AditAudioSink.h>

namespace adit { namespace bdcl {

class NaviTtsAudioChannel : public IAditAudioSinkCallbacks
{
public:
    NaviTtsAudioChannel(CoreCallbackDealer* inCallbackDealer);
    virtual ~NaviTtsAudioChannel();

private:
    AditAudioSink* mAudioSink;

    void onPlaybackInit(unsigned int inSampleRate, unsigned int inChannelConfig, unsigned int inSampleFormat);

    /** @brief Callback initiated by Baidu core to stop audio playback.
     */
    void onPlaybackStop();

    /** @brief Callback initiated by ADIT to inform MC application about an error.
     */
    void onError(bdclErrorCodes inErrorCode);
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_NAVITTSAUDIOCHANNEL_H */
